require("Furry/fur")
require("MF_ISMoodle")

TABAS_FurryShakeAction = ISBaseTimedAction:derive("TABAS_FurryShakeAction")

function TABAS_FurryShakeAction:isValid()
    return true
end

function TABAS_FurryShakeAction:update()
    self.character:setMetabolicTarget(Metabolics.LightDomestic)
end

function TABAS_FurryShakeAction:start()
    self:setActionAnim("Furry_ShakeDry")
end

function TABAS_FurryShakeAction:stop()
    ISBaseTimedAction.stop(self)
end

function TABAS_FurryShakeAction:perform()
    if self.fur ~= nil then
        if self.bathingWet then
            self.bathingWet:setValue(0.5)
        end
        self.character:getModData().bathingWetTimer = 0
        self.fur:setWetness(0)
        self.character:getBodyDamage():setWetness(0)
    end
    ISBaseTimedAction.perform(self)
end

function TABAS_FurryShakeAction:new(character, time)
    local o = ISBaseTimedAction.new(self, character)
    o.fur = FurManager.getPlayerWornFur(character)
    if MF then -- Moodle Framework
        o.bathingWet = MF.getMoodle("Wet_Bathing", character:getPlayerNum())
    end
    o.stopOnAim = true
    o.stopOnWalk = true
    o.stopOnRun = true
    o.maxTime = time
    o.ignoreHandsWounds = true
    o.animSpeed = 1.0
    if o.character:isTimedActionInstant() then o.maxTime = 1 end
    o.timer = time / 20
    o.tick = 0
    o.caloriesModifier = 4
    return o
end

function TABAS_FurryShakeAction.doShakeAction(player, square)
    -- Shake dry
    local shakeAction = TABAS_FurryShakeAction:new(player, 200)
    ISTimedActionQueue.add(shakeAction)
end

